<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../classi/Video.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $video = new Video($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $video = new Video($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $video->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $video->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $video->setVideo(filter_input(INPUT_POST,"linkVideo",FILTER_SANITIZE_STRING));
            $video->crea();
            header("Location: ../creaVideo.php?id={$video->getId()}&status=200");
            break;
        case 'modifica':
            $video->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $video->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $video->setVideo(filter_input(INPUT_POST,"video",FILTER_SANITIZE_STRING));
            $video->modifica();
            header("Location: ../creaVideo.php?id={$video->getId()}&status=250");
            break;
        case 'modificaFileVideo':
            $tipiFileAmmessi = array("video/mp4","video/avi","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../file/video", 0, "");
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["percorso"]=="") {
                echo "Errore: formato immagine non ammesso";
                exit();
            }
            else {
                $percorsoVideo = str_replace("../","",$esitoUpload["percorso"]);
            }
            $video->aggiornaPercorsoVideo($percorsoVideo);
            echo $percorsoVideo;
            break;
        case 'duplica':
            $idVideoDuplicato = $video->duplica();
            header("Location: ../creaVideo.php?id={$idVideoDuplicato}&status=210");
            break;
        case 'elimina':
            $video->elimina();
            echo "ok";
            break;
    }
